class Ex7_5
parameter Real v(unit="m/s")=140*(1000/3600);/*speed of the train*/
parameter Real theta_deg(unit="deg N")=27;/*latitude of the location in degree unit*/ 
Real theta(unit="rad N");/*latitude of the location in radian unit*/
parameter Real m(unit="kg")=1.5*10^5;/*mass of the locomotive*/
parameter Real w(unit="rad/s")=7.27*10^(-5);/*angular velocity of the earth*/
Real w_r(unit="rad/s");/*component of the angular velocity of the earth along the local vertical at the location*/
Real F(unit="N");/*sidewise thrust exerted by the locomotive*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
w_r=w*sin(theta);
F=2*m*w_r*v;
end Ex7_5;
