class Ex2_11
parameter Real g(unit="m/s^2")=9.83;/*acceleration due to gravity*/
parameter Real r_1o(unit="m")=100;/*initial position of the 1 stone from ground*/
parameter Real v2o(unit="m/s")=80;/*initial velocity of the 2nd stone*/

Real t(unit="s");/*required collision time after dropping the 1st stone*/
Real r1(unit="m");/*postion of the 1st stone from ground at the collision time*/ 
Real r2(unit="m");/*postion of the 2nd stone from ground at the collision time*/
Real v1(unit="m/s");/*velocity of the 1st stone at the collision time*/
Real v2(unit="m/s");/*velocity of the 2nd stone at the collision time*/
Real v12(unit="m/s");/*the speed with which the collision happen*/
equation
r1=100-(1/2)*g*t^2;
r2=v2o*(t-2)-(1/2)*g*(t-2)^2;
r1=r2;
v1=-g*t;
v2=v2o-g*(t-2);
v12=abs(v1-v2);
end Ex2_11;
