class Ex2_16
parameter Real g(unit="m/s^2")=9.83;/*acceleration due to gravity*/

parameter Real x_0(unit="m")=0;/*initial x-coordinate of the bomber*/
parameter Real y_0(unit="m")=3000;/*initial y-coordinate of the bomber*/
parameter Real v_x0(unit="m/s")=300*(1000/3600);/*initial velocity along x-axis*/
parameter Real v_y0(unit="m/s")=0;/*initial velocity along y-axis*/

parameter Real a_x(unit="m/s^2")=0;/*acceleration along x-axis*/
parameter Real a_y(unit="m/s^2")=g;/*acceleration along y-axis*/

Real t_f(unit="s");/*time to reach the bomb at ground*/

parameter Real y_t_f(unit="m")=0;/*final y-coordinate of the bomb*/
Real x_t_f(unit="m");/*ifinal x-coordinate of the bomb*/
equation
t_f=sqrt((2*(y_0-y_t_f))/a_y);
x_t_f=v_x0*t_f;
end Ex2_16;
