class Ex2_17
parameter Real g(unit="m/s^2")=9.83;/*acceleration due to gravity*/

parameter Real v_0(unit="m/s")=40;/*initial speed of the projectile*/
parameter Real theta_deg(unit="deg")=60;/*angle between direction of velocity of projectile and x-axis in degree unit*/
Real theta_rad(unit="rad");/*angle between direction of velocity of projectile and x-axis in radian unit*/
Real a_nA(unit="m/s^2");/*normal component of acceleration at point A*/
Real rho_A(unit="m");/*radius of curvature at point A*/

Real v_C(unit="m/s");/*velocity of the particle at point C*/
Real a_nC(unit="m/s^2");/*normal component of acceleration at point C*/
Real rho_C(unit="m");/*radius of curvature at point C*/

Real v_Ay(unit="m/s");/*y-component of the velocity of the particle at point A*/
Real h(unit="m");/*maximum height reach by the projectile*/
Real v_Bx(unit="m/s");/*x-component of the velocity of the particle at point B*/
Real v_By(unit="m/s");/*y-component of the velocity of the particle at point B*/

Real beta(unit="rad");/*flight path angle at B*/

Real v_B(unit="m/s");/*velocity of the particle at point B*/
Real a_nB(unit="m/s^2");/*normal component of acceleration at point B*/
Real rho_B(unit="m");/*radius of curvature at point B*/
equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
a_nA=g*cos(theta_rad);
a_nA=v_0^2/rho_A;

v_C=v_0*cos(theta_rad);
a_nC=g;
a_nC=v_C^2/rho_C;

v_Ay=v_0*sin(theta_rad);
v_Bx=v_0*cos(theta_rad);
0=v_Ay^2-2*g*h;
v_By^2=v_Ay^2-2*g*(h/2);
tan(beta)=v_By/v_Bx;

a_nB=g*cos(beta);
v_B=sqrt(v_Bx^2+v_By^2);
a_nB=v_B^2/rho_B;
end Ex2_17;
