class Ex2_25
parameter Real SB(unit="m")=5*10^3;/*distance between ship and object*/
parameter Real V_B1S(unit="m/s")=(50*10^3)/3600;/*speed of the object 1 w.r.t. ship*/
parameter Real theta_deg(unit="deg")=60;/*direction of the object 1 w.r.t. zeta-axis in degree unit*/
Real theta_rad(unit="deg");/*direction of the object 1 w.r.t. zeta-axis in radian unit*/
Real v_B1S[2](each unit="m/s");/*velocity of the object 1 w.r.t. ship in zeta-eta coordinate system*/
Real a_S[2](each unit="m/s^2");/*acceleration of the ship*/
Real a_B1S[2](each unit="m/s^2");/*acceleration of the object 1 w.r.t. ship*/
Real zeta_B1(unit="m");/*position of object 1 w.r.t. ship in zeta-axis*/
Real eta_B1(unit="m");/*position of object 1 w.r.t. ship in eta-axis*/
Real d(unit="m");/*distance between ship and object1*/
equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
v_B1S={-V_B1S*cos(theta_rad),-V_B1S*sin(theta_rad)};
a_S={0,-0.05};
a_B1S={0,0.05};
zeta_B1=SB*cos(theta_rad)-V_B1S*cos(theta_rad)*time;
eta_B1=SB*sin(theta_rad)-V_B1S*sin(theta_rad)*time+(1/2)*a_B1S[2]*time^2;
d=sqrt(zeta_B1^2+eta_B1^2);
end Ex2_25;
