class Ex3_1
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real T(unit="N")=80;/*force applied to each rope*/
Real T_v(unit="N");/*total vertical component of applied force*/
parameter Real theta_deg(unit="deg")=30;/*direction of applied force w.r.t. upward direction in degree unit*/
Real theta_rad(unit="deg");/*direction of applied force w.r.t. upward direction in radian unit*/
parameter Real m(unit="kg")=10;/*mass of the object*/
Real a(unit="m/s^2");/*acceleration of the object*/
equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
T_v=2*T*cos(theta_rad);
m*a=T_v-m*g;
end Ex3_1;
