class Ex3_16
parameter Real pi = Modelica.Constants.pi;

parameter Real G(unit="m^3.kg^(-1).s^(-2)")=6.67*10^(-11);/*constant of the universal gravitational*/
parameter Real m_M(unit="kg")=0.0716*10^24;/*mass of the moon*/
parameter Real r_M(unit="m")=1740*10^3;/*radius of the moon*/ 
parameter Real h(unit="m")=10*10^3;/*altitude of the orbit from the moon surface*/

Real r(unit="m");/*distance of the orbit from the center of the moon*/
Real v(unit="m/s");/*required orbital speed of the satellite*/
parameter Real T(unit="s")=2.5514784*10^6;/*orbital period of the moon*/
Real r_s(unit="m");/*distance of the synchronous orbit from the center of the moon*/
equation
r=r_M+h;
v=sqrt((G*m_M)/r);
r_s=((T*sqrt(G*m_M))/(2*pi))^(2/3);
/*The  answer of r_s provided in the textbook is wrong*/
end Ex3_16;
