class Ex5_16
parameter Real m1(unit="kg")=2;/*mass of the particle 1*/
parameter Real m2(unit="kg")=5;/*mass of the particle 2*/
parameter Real u1(unit="m/s")=18;/*velocity of the particle 1 before collision in laboratory frame*/
parameter Real u2(unit="m/s")=7;/*velocity of the particle 2 before collision*/
Real V(unit="m/s");/*velocity of the center of mass*/
Real U1(unit="m/s");/*velocity of the particle 1 in CM frame before collsion*/
Real U2(unit="m/s");/*velocity of the particle 2 in CM frame before collsion*/
Real V1(unit="m/s");/*velocity of the particle 1 in CM frame after collsion*/
Real V2(unit="m/s");/*velocity of the particle 2 in CM frame after collsion*/
Real v1(unit="m/s");/*velocity of the particle 1 after collision in laboratory frame*/
Real v2(unit="m/s");/*velocity of the particle 2 after collision in laboratory frame*/
equation
V=(m1*u1+m2*u2)/(m1+m2);
U1=u1-V;
U2=u2-V;
V1=-U1;
V2=-U2;
v1=V1+V;
v2=V2+V;
end Ex5_16;
