class Ex5_3
parameter Real m_A(unit="kg")=0.5;/*mass of the particle A*/
parameter Real v_A_mag(unit="m/s")=0.3;/*magnitude of the velocity of the particle A*/
Real v_A[2](each unit="m/s");/*velocity of the particle A*/

parameter Real m_B(unit="kg")=1;/*mass of the particle B*/
parameter Real v_B_mag(unit="m/s")=0.1;/*magnitude of the velocity of the particle B*/
parameter Real theta_deg(unit="deg")=60;/*direction of velocity of B w.r.t.direction of velocity of A in degree unit*/
Real theta(unit="deg");/*direction of velocity of B w.r.t.direction of velocity of A in radian unit*/
Real v_B[2](each unit="m/s");/*velocity of the particle B*/

Real p_A[2](each unit="kg.m.s^(-1)");/*momentum vector of A*/
Real p_B[2](each unit="kg.m.s^(-1)");/*momentum vector of B*/
Real p_S1[2](each unit="kg.m.s^(-1)");/*momentum vector of system before collision*/
Real p_S2[2](each unit="kg.m.s^(-1)");/*momentum vector of system after collision*/

Real v[2](each unit="m/s");/*final velocity of the system*/
Real theta_f_rad(unit="rad");/*direction of the combined system after collision in radian unit*/
Real theta_f(unit="deg");/*direction of the combined system after collision in degree unit*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
v_A=v_A_mag*{1,0};
v_B=v_B_mag*{-cos(theta),sin(theta)};
p_A=m_A*v_A;
p_B=m_B*v_B;
p_S1=p_A+p_B;
p_S2=(m_A+m_B)*v;
p_S2=p_S1;
theta_f_rad=atan(v[2]/v[1]);
theta_f=Modelica.SIunits.Conversions.to_deg(theta_f_rad);
// Given value of m_A is wrong in the book
end Ex5_3;
