class Ex6_1
parameter Real m(unit="kg")=20;/*mass of the disc*/
parameter Real D_C(unit="m")=20/100;/*diameter of the disc*/
Real r_C(unit="m");/*radius of the disc*/
parameter Real v_C(unit="m/s")=1.5;/*speed of the disc center*/
Real w(unit="rad/s");/*angular velocity of the disc*/
Real p(unit="kg.m.s^(-1)");/*magnitude of the liniar momentum*/
Real I_C(unit="kg.m^2");/*moment of inertia about center C*/
Real l_A(unit="kg.m^2.s^(-1)");/*magnitude of angulat momentum about point A*/
equation
r_C=D_C/2;
v_C=w*r_C;
p=m*v_C;
I_C=(1/2)*m*r_C^2;
l_A=r_C*p+I_C*w;
/*The  answer provided in the textbook for l_A is wrong*/
end Ex6_1;
