class Ex6_5
parameter Real pi = Modelica.Constants.pi;

parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=50;/*mass of the disc*/
parameter Real r(unit="m")=10/100;/*radius of the disc*/

parameter Real theta_deg(unit="deg")=60;/*angle between line OC and vertical in degree unit*/
Real theta(unit="rad");/*angle between line OC and vertical in radian unit*/

parameter Real OC(unit="m")=6/100;/*distance between O and C*/
Real I_C(unit="kg.m^2");/*mass moment of inertia about C*/
Real I_O(unit="kg.m^2");/*mass moment of inertia about O*/
Real F(unit="N");/*resultant force*/
Real alpha(unit="rad/s^2");/*angular acceleration*/
Real R(unit="N");/*reaction force*/
Real beta_rad(unit="rad",start=0.001);/*direction of reaction w.r.t. weight in degree unit*/
Real beta(unit="deg");/*direction of reaction force w.r.t. weight in degree unit*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
I_C=(1/2)*m*r^2;
I_O=I_C+m*OC^2;
alpha=(m*g*OC*sin(theta))/I_O;
F=m*alpha*OC;
F^2=((m*g)^2+R^2+2*(m*g)*R*cos(pi-beta_rad));
F/sin(beta_rad)=R/cos(pi/2-theta);
beta=Modelica.SIunits.Conversions.to_deg(beta_rad);
/*The  answer provided for R in the textbook is wrong*/
end Ex6_5;
