class Ex6_7
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m(unit="kg")=10;/*mass of the cylinder*/
parameter Real r_c(unit="m")=3/100;/*radius of the cylinder*/
parameter Real r_s(unit="m")=5/100;/*radius of the cylinder surface*/
parameter Real theta_deg(unit="deg")=30;/*rotational angle of the cylinder in degree unit*/
Real theta(unit="rad");/*rotational angle of the cylinder in radian unit*/
Real h(unit="m");/*drop in height of the cylinder center*/
Real w(unit="rad/s");/*angular velocity of the cylinder*/
Real I(unit="kg.m^2");/*mass moment of inertia*/
Real v(unit="m/s",start=0.001);/*velocity of the cylinder center*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
h=(r_c+r_s)*(1-cos(theta));
I=(1/2)*m*r_c^2;
v=w*r_c;
0=(1/2)*I*w^2+(1/2)*m*v^2-m*g*h;
/*The  answer provided in the textbook is wrong*/
end Ex6_7;
