class Ex7_18
parameter Real G(unit="m3.kg^(-1).s^(-2)")=6.67*10^(-11);/*gravitational constant*/
parameter Real m_e(unit="kg")=6*10^24;/*mass of the earth*/
parameter Real m_m(unit="kg")=7.16*10^22;/*mass of the moon*/
parameter Real r_e(unit="m")=6.378*10^6;/*radius of the earth*/
parameter Real r_m(unit="m")=1.740*10^6;/*radius of the moon*/
Real v_escape_e(unit="kms^(-1)");/*escape velocity from earth surface*/
Real v_escape_m(unit="kms^(-1)");/*escape velocity from moon surface*/
equation
v_escape_e=(sqrt((2*G*m_e)/r_e))/1000;/*here v_escape_e has been divided by 1000 to convert the unit from m/s to km/s*/
v_escape_m=(sqrt((2*G*m_m)/r_m))/1000;/*here v_escape_e has been divided by 1000 to convert the unit from m/s to km/s*/
end Ex7_18;
