class Ex10_4
/*for case a*/
parameter Real pi=Modelica.Constants.pi;
parameter Real R(unit="J/kg·K")=287"specefic gas constant of air";
parameter Real k=1.4"ratio of specefic heat at constant pressure to specefic heat at constant volume";

parameter Real d_ne(unit="m")=0.75/100"diameter of the exit";
parameter Real T_t_degC(unit="degC")=22"cabin temperature in degree celcius";
Real T_t(unit="K")"cabin temperature in Kelvin unit";
parameter Real p_t1(unit="N/m^2")=0.5*10^5"cabin pressure";
parameter Real p_ne(unit="N/m^2")=0.47218*10^5"nozzle exit pressure";
Real T_ne(unit="K")"nozzle exit temperature";
parameter Real M_ne=0.2872"Mach number at nozzle exit";
Real rho_ne(unit="kg/m^3")"density at nozzle exit";
Real U_ne(unit="m/s")"velocity at nozzle exit";
Real A_ne(unit="m^2")"cross section area of the exit";
Real m_dot(unit="kg/s")"mass flow rate";
equation
A_ne=(1/4)*pi*d_ne^2;
T_t=Modelica.SIunits.Conversions.from_degC(T_t_degC);
T_ne=T_t/(1+((k-1)/2)*M_ne^2);
rho_ne=p_ne/(R*T_ne);
U_ne=M_ne*sqrt(k*R*T_ne);
m_dot=rho_ne*U_ne*A_ne;
/*The  answer may slightly vary due to  rounding off values*/
end Ex10_4;
