class Ex5_1
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.8066"acceleration due ro gravity";

parameter Real rho(unit="kg/m^3")=1000"density of the water";
parameter Real Q(unit="m^3/s")=0.001*pi"volume flow rate";
parameter Real D1(unit="m")=5/100"diameter of cross section 1";
parameter Real D2(unit="m")=2/100"diameter of cross section 2";
parameter Real z1(unit="m")=30/100"height of the center of cross section 1";
parameter Real z2(unit="m")=0"height of the center of cross section 2";
Real A1(unit="m^2")"area of the cross section of section 1";
Real A2(unit="m^2")"area of the cross section of section 2";
Real V1(unit="m/s")"velocity in section 1";
Real V2(unit="m/s")"velocity in section 2";
parameter Real p_atm(unit="N/m^2")=1.01325*10^5"pressure at section 2";
Real p1(unit="N/m^2")"pressure at section 1";
equation
A1=(1/4)*pi*D1^2;
A2=(1/4)*pi*D2^2;
V2=Q/A2;
V1=(D2/D1)^2*V2;
V1^2/2+g*z1+p1/rho=V2^2/2+g*z2+p_atm/rho;
/*The  answer provided in the textbook is wrong*/
end Ex5_1;
