class Ex9_3
parameter Real phi_deg(unit="deg")=45"inclination of the channel's slant edge in degree unit";
Real phi(unit="rad")"inclination of the channel's slant edge in radian unit";
parameter Real S_0=0.0009"slope of the floor";
parameter Real y_c(unit="ft")=16;
parameter Real y_f(unit="ft")=8;

parameter Real n_1=0.03"Manning's coefficient for channel";
parameter Real b_1(unit="ft")=40"base length for channel";
Real A_1(unit="ft^2")"cross-sectional area of the channel";
Real P_1(unit="ft")"perimeter of the channel";
Real y_n(unit="ft")"normal depth of the channel";
Real K_1"conveyance of the channel section";

parameter Real n_2=0.05"Manning's coefficient for floodplain";
parameter Real b_2(unit="ft")=100"base length of the floodplain";
Real A_2(unit="ft^2")"cross-sectional area of the floodplain";
Real P_2(unit="ft")"perimeter of the floodplain";
Real K_2"conveyance of the floodplain section";
 
Real Q(unit="ft^3/s")"discharge rate";
equation
phi=Modelica.SIunits.Conversions.from_deg(phi_deg);
y_n=y_c+y_f;
A_1=y_n*(b_1+y_n/tan(phi))-(1/2)*y_f^2/tan(phi);
P_1=y_n/sin(phi)+b_1+y_c/sin(phi);
K_1=(1.49/n_1)*(A_1^(5/3)/P_1^(2/3));

A_2=y_f*(b_2+y_f/tan(phi))-(1/2)*y_f^2/tan(phi);
P_2=b_2+y_f/sin(phi);
K_2=(1.49/n_2)*(A_2^(5/3)/P_2^(2/3));

Q=(K_1+K_2)*S_0^0.5;


end Ex9_3;
