class Ex9_4
parameter Real S_0=0.0005"slope of the channel";
parameter Real Q(unit="m^3/s")=40"volume flow rate";

parameter Real n_a=0.015"Manning's coefficient for case a";
Real y_n_a(unit="m",start=0.001)"normal depth of the channel for case a";
Real R_h_a(unit="m")"hydraulic radius for case a";
Real A_a(unit="m^2")"cross-sectional area of the channel for case a";
Real b_a(unit="m")"base length for channel for case a";

parameter Real m=1/sqrt(3)"for case b";
parameter Real n_b=0.015"Manning's coefficient for case b";
Real y_n_b(unit="m",start=0.001)"normal depth of the channel for case b";
Real R_h_b(unit="m")"hydraulic radius for case b";
Real A_b(unit="m^2")"cross-sectional area of the channel for case b";
Real b_b(unit="m")"base length for channel for case b";

equation
R_h_a=y_n_a/2;
A_a=2*y_n_a^2;
Q=(1/n_a)*A_a*R_h_a^(2/3)*S_0^0.5;
b_a=2*y_n_a;

R_h_b=y_n_b/2;
A_b=y_n_b^2*(2*(1+m^2)^0.5-m);
Q=(1/n_b)*A_b*R_h_b^(2/3)*S_0^0.5;
b_b=A_b/y_n_b-m*y_n_b;

end Ex9_4;
