class Ex9_6
parameter Real g(unit="m/s^2")=9.8066"acceleration due to gravity";

parameter Real b(unit="m")=10"width of the channel";
parameter Real V_1(unit="m/s")=10"velocity of the flow before jump";
parameter Real y_1(unit="m")=2"depth of the channel at station 1";

Real Fr_1"upstream Froude number";
Real y_2(unit="m")"depth of the channel after jump";
Real V_2(unit="m/s")"downstream velocity";
Real Fr_2"downstream Froude number";
Real h_f(unit="m")"head loss";
Real gama(unit="N/m^3")"specefic weight of water";
parameter Real Q(unit="m^3/s")=200"dischaarge rate";
Real P(unit="W")"dissipated power";
equation
Fr_1=V_1/(g*y_1)^0.5;
y_2=(y_1/2)*((1+8*Fr_1^2)^0.5-1);
V_2=(V_1*y_1)/y_2;
Fr_2=V_2/(g*y_2)^0.5;
h_f=(y_2-y_1)^3/(4*y_1*y_2);
gama=0.9982*(9.8066*10^3);
P=Q*gama*h_f;
/*The  answer may slightly vary due to  rounding off values*/
end Ex9_6;
