class Ex10_2
parameter Real R(unit="J/kg·K")=287"specefic gas constant of air";
parameter Real k=1.4"ratio of specefic heat at constant pressure to specefic heat at constant volume";
parameter Real c_p(unit="J/kg.K")=1004.7"specefic heat at constant pressure";

parameter Real p_2(unit="N/m^2")=4.8393*10^4"pressure at point 2";
parameter Real T_2(unit="K")=740"temperature at point 2";
parameter Real p_3(unit="N/m^2")=2.5566*10^4"pressure at point 3";
parameter Real p_4(unit="N/m^2")=5.6609*10^3"pressure at point 4";
Real T_3(unit="K")"temperature at point 3";
Real T_4(unit="K")"temperature at point 4";
Real U_3(unit="m/s")"velocity at point 3";
Real U_4(unit="m/s")"velocity at point 4";
Real a_3(unit="m/s")"speed of sound at point 3";
Real a_4(unit="m/s")"speed of sound at point 4";
Real M_3"Mach number at point 3";
Real M_4"Mach number at point 4";
equation
T_3/T_2=(p_3/p_2)^((k-1)/k);
T_4/T_2=(p_4/p_2)^((k-1)/k);
U_3=(2*c_p*(T_2-T_3))^0.5;
U_4=(2*c_p*(T_2-T_4))^0.5;
a_3=sqrt(k*R*T_3);
a_4=sqrt(k*R*T_4);
M_3=U_3/a_3;
M_4=U_4/a_4;
/*The  answer may slightly vary due to  rounding off values*/
end Ex10_2;
