class Ex10_9
parameter Real pi=Modelica.Constants.pi;
parameter Real R(unit="J/kg·K")=287"specefic gas constant of air";
parameter Real k=1.4"ratio of specefic heat at constant pressure to specefic heat at constant volume";
parameter Real c_p(unit="J/kg.K")=1004.7"specefic heat at constant pressure";

parameter Real D(unit="m")=5/100"diameter of the pipe";
parameter Real p_t1(unit="N/m^2")=150*10^3"total pressure at inlet";
parameter Real T_t1(unit="K")=500"total temperature at inlet";
parameter Real U_0(unit="m/s")=100"velocity at inlet";
Real T_0(unit="K")"static temperature at inlet";
Real a_0(unit="m/s")"speed of sound at inlet";
Real M_0"Mach number at inlet";
parameter Real f_bar=0.02"friction factor";
Real L_star(unit="m")"duct length";
Real rho_t1(unit="kg/m^3")"static density at inlet";
parameter Real rho_0_by_rho_t1=0.9753"ratio of total density to static density at inlet";
Real rho_0(unit="kg/m^3")"total density at inlet";
Real A(unit="m^2")"cross sectional area of the pipe";
Real m_dot(unit="kg/s")"mass flow rate"; 
equation
T_0=T_t1-U_0^2/(2*c_p);
a_0=20.047*sqrt(T_0);
M_0=U_0/a_0;
L_star=(D/f_bar)*(((1-M_0^2)/(k*M_0^2))+((k+1)/(2*k))*log(((k+1)*M_0^2)/(2+(k-1)*M_0^2)));
rho_t1=p_t1/(R*T_t1);
rho_0=rho_0_by_rho_t1*rho_t1;
A=(1/4)*pi*D^2;
m_dot=rho_0*U_0*A;
end Ex10_9;
