class Ex12_2
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.8066"acceleration due to gravity";

parameter Real w(unit="rad/s")=600*((2*pi)/60)"angular velocity of the generator";
parameter Real Q(unit="m^3/s")=0.4"volumetric flow rate of the jet of the water";
parameter Real V_j(unit="m/s")=100"jet velocity";
parameter Real V_b_by_V_j=0.47"ratio of the bucket speed to the initial jet speed";
parameter Real theta_deg(unit="deg")=170"balde angle in degree unit";
Real theta(unit="rad")"balde angle in radian unit";
Real r(unit="m")"radius of the bucket";
Real d(unit="m")"diameter of the bucket";
parameter Real rho(unit="kg/m^3")=1000"density of the water";
Real P(unit="W")"develoed power";
Real V_2x(unit="m/s")"x-component of the absolute velocity of the water";
Real V_2y(unit="m/s")"y-component of the absolute velocity of the water";
Real ke(unit="N.m/N")"remaining kinetic energy per Newton";
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
(r*w)/V_j=V_b_by_V_j;
d=2*r;
P=rho*Q*r*w*(V_j-r*w)*(1-cos(theta));
V_2x=-(V_j-r*w)*cos(theta)-r*w;
V_2y=(V_j-r*w)*sin(theta);
ke=((V_2x^2+V_2y^2)/2)*(1/9.8066);
end Ex12_2;
