class Ex2_10
parameter Real pi=Modelica.Constants.pi;

parameter Real g(unit="m^2/s")=9.8066"acceleration due to gravity";
parameter Real rho_sw(unit="kg/m^3")=1.034*10^3"density of the sea water";

parameter Real W_tra(unit="N")=3*10^3"weight of the tressure in air";
parameter Real V_tr(unit="m^3")=0.10"volume of the tressure";

parameter Real W_odsw(unit="N")=225"weight of the oil drum in seawater";
parameter Real V_od(unit="m^3")=0.20"volume of the oil drum";

Real W_trsw(unit="N")"weight of the tressure in seawater";
Real L_od(unit="N")"lifting power of one oil drum";
Real N"minimum number of required drum";
equation
W_trsw=W_tra-rho_sw*g*V_tr;
L_od=-(W_odsw-rho_sw*g*V_od);
N=ceil(W_trsw/L_od);
end Ex2_10;
