class Ex2_9
parameter Real pi=Modelica.Constants.pi;

parameter Real g(unit="m^2/s")=9.81"acceleration due to gravity";
parameter Real rho(unit="kg/m^3")=1*10^3"density of water";
parameter Real p_atm(unit="N/m^2")=1*1.01325*10^5"standard atmospheric pressure";
parameter Real gama(unit="N/m^3")=9.8066*10^3"specefic weight";

parameter Real OA(unit="m")=1"length of OA";
parameter Real OB(unit="m")=1"length of OB";
parameter Real OC(unit="m")=10"length of OC";
parameter Real R(unit="m")=1"radius of the arc";
parameter Real h_c(unit="m")=10.5"centroid of the projected raea";
parameter Real A(unit="m^2")=1"area of the projected arc";

Real F_Rx(unit="N")"horizontal force";
Real F_Nx(unit="N")"net force in the x-direction";
Real F_Rz(unit="N")"vertical force";
Real F_Nz(unit="N")"net force in the z-direction";
equation
F_Rx=(p_atm+rho*g*h_c)*A;
F_Nx=F_Rx-p_atm*OA*1;
F_Rz=(p_atm+rho*g*OC)*1+rho*g*((pi*R^2)/4);
F_Nz=F_Rz-p_atm*OB*1;
end Ex2_9;
