class Ex6_7
parameter Real R(unit="J/kg.K")=287.05;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p_t(unit="N/m^2")=1013*10^3"stagnation pressure";
parameter Real T_deg(unit="degC")=15"temperature in the tunnel in degree Celcius unit";
Real T(unit="K")"temperature in the tunnel in Kelvin unit";
parameter Real M_infi=0.23"test section Mach number";
parameter Real C_p_a=1"pressure coefficient for condition a";
parameter Real C_p_b=-5"pressure coefficient for condition b";
parameter Real C_p_c=-1.10"pressure coefficient for condition c";

Real rho(unit="kg/m^3")"density in the tunnel";
Real a_infi(unit="m/s")"speed of sound";
Real U_infi(unit="m/s")"free stream velocity";
Real q_infi(unit="N/m^2")"dynamic preeure";
Real p_infi(unit="N/m^2")"free stream pressure";

Real p_a(unit="N/m^2")"pressure for condition a";
Real U_a(unit="m/s")"velocity for condition a";

Real p_b(unit="N/m^2")"pressure for condition b";
Real U_b(unit="m/s")"velocity for condition b";

Real p_c(unit="N/m^2")"pressure for condition c";
Real U_c(unit="m/s")"velocity for condition c";
equation
T=Modelica.SIunits.Conversions.from_degC(T_deg);
rho=p_t/(R*T);
a_infi=sqrt(gama*R*T);
U_infi=M_infi*a_infi;
q_infi=(1/2)*rho*U_infi^2;
p_infi=p_t-(1/2)*rho*U_infi^2;

p_a=p_infi+C_p_a*q_infi;
U_a=U_infi*(1-C_p_a)^0.5;

p_b=p_infi+C_p_b*q_infi;
U_b=U_infi*(1-C_p_b)^0.5;

p_c=p_infi+C_p_c*q_infi;
U_c=U_infi*(1-C_p_c)^0.5;

/*The  answer may slightly vary due to  rounding off values*/
end Ex6_7;
