class Ex7_1
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.8066"acceleration due to gravity";

parameter Real theta_deg(unit="deg")=40"inclination of the pipe in degree unit";
Real theta(unit="rad")"inclination of the pipe in radian unit";
parameter Real D(unit="m")=7/100"diameter of the pipe";
parameter Real L(unit="m")=10"length of the pipe";
parameter Real mu(unit="N.s/m^2")=2*10^(-1)"viscosity of the oil";
parameter Real rho(unit="kg/m^3")=920"density of the oil";
parameter Real p1(unit="N/m^2")=2.49*10^5"static pressure at station 1(the value of p1 in the book is wrong)";
parameter Real p2(unit="N/m^2")=1.49*10^5"static pressure at station 1(the value of p2 in the book is wrong)";
parameter Real z1(unit="m")=0"altitude of station 1";
Real z2(unit="m")"altitude of station 2";

Real HGL_1(unit="m")"hydraulic grade line at station 1";
Real HGL_2(unit="m")"hydraulic grade line at station 2";
Real h_f(unit="m")"head loss due to the friction";
Real v_avg(unit="m/s")"average velocity";
Real Re_D(unit="m")"Reynolds number";
Real Q(unit="m^3/s")"volume flow rate";
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
z2=L*sin(theta);
HGL_1=z1+p1/(rho*g);
HGL_2=z2+p2/(rho*g);
h_f=HGL_1-HGL_2;
v_avg=(rho*g*D^2*h_f)/(32*mu*L);
Re_D=(rho*v_avg*D)/mu;
Q=v_avg*((pi*D^2)/4);
end Ex7_1;
