class Ex7_2
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.8066"acceleration due to gravity";
parameter Real D(unit="m")=20/100"diameter of the pipe";
parameter Real L(unit="m")=300"length of the pipe";
parameter Real nu(unit="m^2/s")=1*10^(-5)"kinematic viscosity of the oil";
parameter Real rho(unit="kg/m^3")=920"density of the oil";
parameter Real Q(unit="m^3/s")=0.126"volume flow rate";

Real v_avg(unit="m/s")"average velocity";
Real Re_D"Reynolds number";
Real f"friction factor";
Real h_f(unit="m")"head loss";
equation
v_avg=Q/(pi*(D^2/4));
Re_D=v_avg*D/nu;
f=0.0235;
h_f=(v_avg^2/(2*g))*(L/D)*f;
/*instead of putting head loss equation,equation for pressure drop has been taken in the book which should not be taken as it has been asked to find out the head loss for the system*/
end Ex7_2;
