class Ex9_2
parameter Real n=0.025"Manning's coefficient";

parameter Real b(unit="ft")=10"base length";
parameter Real S_0=0.002"slope of the floor";
parameter Real m=2;

Real phi(unit="rad")"inclination of the channel's slant edge in radian unit";
 
Real A(unit="ft^2")"cross-sectional area";
Real R_h(unit="ft")"hydraulic radius";
Real P(unit="ft")"perimeter";

parameter Real Q(unit="cfs")=1000"volumetric flow rate from Manning's formula";
Real y_n(unit="ft",start=0.001)"normal depth";
equation
phi=atan(1/m);
A=y_n*((2*b+2*y_n*(1/tan(phi)))/2);
P=b+2*y_n*(1/sin(phi));
R_h=A/P;
Q=(1.49/n)*(A^(5/3)/P^(2/3))*S_0^0.5;
end Ex9_2;
