class Ex2_6
parameter Real g(unit="m^2/s")=9.81"acceleration due to gravity";
parameter Real p_atm(unit="N/m^2")=1*1.01325*10^5"standard atmospheric pressure";
parameter Real rho_H20(unit="kg/m^3")=1*10^3"density of water";
parameter Real S_oil=0.90"specefic gravity of oil";
Real rho_oil(unit="kg/m^3")"density of oil";
parameter Real h1(unit="m")=3.6/100"distance between centerline and level of water in left hand leg";
parameter Real h2(unit="m")=15/100"differential height";
Real p(unit="N/m^2")"pressure in the horizontal plane of interest";
Real p_cl(unit="N/m^2")"pressure in the centerline of the pipe";
Real p_cl_p_atm(unit="N/m^2")"differential pressure";
equation
rho_oil=S_oil*rho_H20;
p=p_atm+rho_H20*g*h2;
p=p_cl+rho_oil*g*h1;
p_cl_p_atm=p_cl-p_atm;
end Ex2_6;
