class Ex7_5
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.8066"acceleration due to gravity";
parameter Real rho(unit="kg/m^3")=1000"density of the water";

parameter Real D1(unit="m")=15/100"diameter of the pipe of station 1";
parameter Real p1(unit="Pa")=250*10^3"pressure in the pipe of station 1";
parameter Real V1(unit="m/s")=8"velocity in the pipe of station 1";
parameter Real z1(unit="m")=0"altitude of station 1";

parameter Real D2(unit="m")=10/100"diameter of the pipe of station 2";
parameter Real p2(unit="Pa")=200*10^3"pressure in the pipe of station 2";
parameter Real z2(unit="m")=15"altitude of station 2";

Real A1(unit="m^2")"cross sectional area of station 1";
Real A2(unit="m^2")"cross sectional area of station 2";
Real m_dot(unit="kg/s")"mass flow rate";
Real V2(unit="m/s")"velocity in the pipe of station 2";

Real W_s_dot1(unit="W")"required power for condition 1";

parameter Real K=2.5"loss factor";
Real W_s_dot2(unit="W")"required power for condition 2";
equation
A1=(1/4)*pi*D1^2;
A2=(1/4)*pi*D2^2;
V2=V1*(D1/D2)^2;
m_dot=rho*V1*A1;
W_s_dot1=-rho*V1*A1*(V1^2/2+g*z1+p1/rho)+rho*V2*A2*(V2^2/2+g*z2+p2/rho);
W_s_dot2=-rho*V1*A1*(V1^2/2+g*z1+p1/rho)+rho*V2*A2*(V2^2/2+g*z2+p2/rho)+m_dot*K*(V1^2/2);

/*The  answer may slightly vary due to  rounding off values*/
end Ex7_5;
