class Ex8_8
parameter Real p_infi(unit="N/m^2")=7.012*10^4"free-stream pressure";
parameter Real T_infi(unit="K")=268.659"free-stream temperature";
parameter Real T_w(unit="K")=330"surface temperature";
parameter Real rho_infi(unit="kg/m^3")=0.9092"free-stream density";
parameter Real mu_infi(unit="kg/s.m")=1.6938*10^(-5)"free-stream viscosity";
parameter Real u_e(unit="m/s")=(468*1000)/3600"velocity of the airplane";
parameter Real x(unit="m")=3"given length";
Real Re_x "Reynolds number";
Real x_tr(unit="m")"transition point";
Real k(unit="J/m.s.K")"thermal conductivity";
parameter Real c_p(unit="J/kg.K")=1004.7"specefic heat at constant pressure";
Real Pr"Prandtl number";
Real q_dot(unit="W/m^2")"local heating rate";
equation
Re_x=(rho_infi*u_e*x)/mu_infi;
x_tr=500000/((rho_infi*u_e)/mu_infi);
k=4.76*10^(-6)*(T_infi^1.5/(T_infi+112))*4.187*100;
Pr=(mu_infi*c_p)/k;
q_dot=(0.0292*Re_x^0.8*Pr^0.333*k*(T_infi-T_w))/x;
end Ex8_8;
