class Ex9_1
parameter Real g(unit="m/s^2")=9.8066"acceleration due to gravity";

parameter Real y_n(unit="m")=3"normal depth";
parameter Real b(unit="m")=4"base length";
parameter Real phi_deg(unit="deg")=50"inclination of the channel's slant edge in degree unit";
Real phi(unit="rad")"inclination of the channel's slant edge in radian unit";
parameter Real theta_deg(unit="deg")=0.5"inclination of the floor of the channel degree unit";
Real theta(unit="rad")"inclination of the floor of the channel radian unit";
Real b_0(unit="m")"surface length";
Real w(unit="m")"slant length of the channel"; 
Real A(unit="m^2")"cross-sectional area";
Real R_h(unit="m")"hydraulic radius";
Real P(unit="m")"perimeter";
Real S_0"slope of the floor";
parameter Real n=0.012"Manning's coefficient";
Real Q1(unit="m^3/s")"volumetric flow rate from Manning's formula";

parameter Real epsilon(unit="m")=1*10^(-3)"average roughness height";
Real f"friction factor";
Real Q2(unit="m^3/s")"volumetric flow rate using friction factor";
equation
phi=Modelica.SIunits.Conversions.from_deg(phi_deg);
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
b_0=y_n*(1/tan(phi));
w=y_n*(1/sin(phi));
A=y_n*((2*b+2*b_0)/2);
P=b+2*w;
R_h=A/P;
S_0=tan(theta);

Q1=(1/n)*A*R_h^(2/3)*S_0^0.5;

f=0.113*(epsilon/R_h)^(1/3);

Q2=((8*g)/f)^0.5*(R_h*S_0)^0.5*A;
end Ex9_1;
