class Ex1_7
parameter Real R(unit="ft.lbf/lbm.degR")=53.34"specefic gas constant";
parameter Real p(unit="lbf/ft^2")=499.34"air pressure";
parameter Real T(unit="degR")=394.06"air temperature";
Real rho1(unit="lbm/ft^3")"air density";
Real rho2(unit="slug/ft^3")"air density";
Real mu(unit="lbf.s/ft^2")"air absolute viscosity";
Real nu(unit="ft^2/s")"kinematics viscosity";
equation
rho1=p/(R*T);
rho2=rho1/32.174;/*here rho1 has been divide by 32.174 to convert the unit from lbm/ft^3 to slug/ft^3*/
mu=2.27*10^(-8)*(T^1.5/(T+198.6));
nu=mu/rho2;
/*The  answer may slightly vary due to  rounding off values*/
end Ex1_7;
