class Ex10_7
parameter Real p_1(unit="N/m^2")=1.01325*10^5"pressure ahead of the shock";
parameter Real T_1(unit="K")=288.15"temperature ahead of the shock";
parameter Real a_1(unit="kg/m^3")=340.294"speed of sound ahead of the shock";
parameter Real U_1(unit="m/s")=1000"velocity of the shock";
Real M_1"Mach nuber of the shock";
parameter Real p_2_p_1=9.911"ratio of pressure behind and ahead of shock";
parameter Real T_2_T_1=2.608"ratio of temperature behind and ahead of shock";
parameter Real rho_2_rho_1=3.800"ratio of density behind and ahead of shock";

Real p_2(unit="N/m^2")"pressure behind of the shock";
Real T_2(unit="K")"temperature behind of the shock";

Real U_2(unit="m/s")"velocity of the air  behind the shock w.r.t shock";
Real U_ds(unit="m/s")"actual velocity of the air  behind the shock";
Real M_ds"Mach number of the shock-induced motion";
equation
M_1=U_1/a_1;
p_2=p_2_p_1*p_1;
T_2=T_2_T_1*T_1;
U_2=(1/rho_2_rho_1)*U_1;
U_ds=U_1-U_2;
M_ds=U_ds/(20.047*sqrt(T_2));
/*The  answer may slightly vary due to  rounding off values*/
end Ex10_7;
