class Ex12_3
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.8066"acceleration due to gravity";

parameter Real z_1(unit="m")=1400"elevation of the free surface of the headwater";
parameter Real z_j(unit="m")=1100"elevation of the nozle";
parameter Real f=0.0225"effective resistance";

parameter Real D_2(unit="m")=75/100"diameter of the pipe";
parameter Real L(unit="m")=1000"length of the pipe";
parameter Real D_j(unit="m")=15/100"diameter of the jet";

parameter Real p_1(unit="N/m^2")=1.01325*10^5"pressure on the free surface of the headwater";
parameter Real p_j(unit="N/m^2")=1.01325*10^5"pressure on the jet";

parameter Real V_1(unit="m/s")=0"velocity of the free surface of the headwater";
Real V_j(unit="m/s",start=0.001)"velocity of the jet";

Real A_j(unit="m^2")"cross section area of the jet";
Real A_2(unit="m^2")"cross section area of penstock pipe";

Real V_2(unit="m/s")"velocity in the penstock pipe";
Real h_f(unit="m")"head loss";

parameter Real theta_deg(unit="deg")=173"balde angle in degree unit";
Real theta(unit="rad")"balde angle in radian unit";

Real Q(unit="m^3/s")"volume flow rate";
parameter Real rho(unit="kg/m^3")=999.3"density of the water";

Real P(unit="W")"gross power";
parameter Real eta=85/100"efficiency of the turbine";
Real Output(unit="W")"power output of the turbine";
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
A_j=(1/4)*pi*D_j^2;
A_2=(1/4)*pi*D_2^2;

V_1^2/(2*g)+z_1+p_1/(rho*g)=V_j^2/(2*g)+z_j+p_j/(rho*g)+h_f;

h_f=(V_2^2/(2*g))*(L/D_2)*f;
V_2=sqrt(V_j^2*(D_j/D_2)^4);

Q=V_j*A_j;
P=rho*Q*(V_j^2/4)*(1-cos(theta));
Output=P*eta;

end Ex12_3;
