class Ex12_4
parameter Real pi=Modelica.Constants.pi;
parameter Real r_1(unit="ft")=5"radius of the blade";
parameter Real w(unit="rad/s")=100*((2*pi)/60)"angular velocity of the turbine";
parameter Real alpha_1deg(unit="deg")=20"angle at the end of the stationary blade in degree unit";
Real alpha_1(unit="rad")"angle at the end of the stationary blade in radian unit";
parameter Real beta_1deg(unit="deg")=60"inlet angle in degree unit";
Real beta_1(unit="rad")"inlet angle in radian unit";
Real V_1(unit="m/s")"velocity of the flow";
equation
alpha_1=Modelica.SIunits.Conversions.from_deg(alpha_1deg);
beta_1=Modelica.SIunits.Conversions.from_deg(beta_1deg);
V_1=(r_1*w)/(cos(alpha_1)-sin(alpha_1)*(1/tan(beta_1)));
end Ex12_4;
