class Ex6_2
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.8066"acceleration due ro gravity";

parameter Real rho(unit="kg/m^3")=1000"density of the water";
parameter Real gama(unit="N/m^3")=9.807*1000"specefic weight of water";
parameter Real Q(unit="m^3/s")=0.1"volume flow rate";
parameter Real V(unit="m^3")=0.1"volume of water inside of the elbow";
parameter Real W(unit="N")=450"weigh of the metal wall";
parameter Real D1(unit="m")=20/100"diameter of cross section 1";
parameter Real D2(unit="m")=10/100"diameter of cross section 2";
parameter Real L(unit="m")=35/100"length of the elbow";
parameter Real z1_z2(unit="m")=35/100"difference of height between two cross section";

Real A1(unit="m^2")"area of the cross section of section 1";
Real A2(unit="m^2")"area of the cross section of section 2";
Real V1(unit="m/s")"velocity in section 1";
Real V2(unit="m/s")"velocity in section 2";
Real m_dot(unit="kg/s")"mass flow rate";
parameter Real p2(unit="N/m^2")=1.01325*10^5"pressure at section 2";
Real p1(unit="N/m^2")"pressure at section 2";
Real F_FPx(unit="N")"force in the x direction";
Real F_Nx(unit="N")"net force in the x-direction";
Real F_FPz(unit="N")"force of the fluid on the elbow in the vertical direction";
Real R_z(unit="N")"net force in  the vertical direction";
equation
A1=(1/4)*pi*D1^2;
A2=(1/4)*pi*D2^2;
V1=Q/A1;
V2=Q/A2;
m_dot=rho*Q;
p1=p2+rho*g*z1_z2+(1/2)*rho*V2^2-(1/2)*rho*V1^2;

F_FPx=p1*A1+p2*A2+m_dot*(V1+V2);
F_Nx=F_FPx-p2*(A1+A2);
F_FPz=-gama*V;
R_z=W+abs(F_FPz);
end Ex6_2;
