class Ex6_5
parameter Real pi=Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.8066"acceleration due ro gravity";

parameter Real rho(unit="kg/m^3")=1000"density of the water";
parameter Real D2(unit="m")=3/100"diameter of section 2";
parameter Real D3(unit="m")=3/100"diameter of section 3";
parameter Real D4(unit="m")=1.5/100"diameter of section 3";
parameter Real z1_z2(unit="m")=50"difference of height between point 1 and 2";
parameter Real z4_z3(unit="m")=0"difference of height between point 3 and 4";
parameter Real V1(unit="m/s")=0"velocity in section 1";
parameter Real V4(unit="m/s")=12"velocity in section 4";

Real A2(unit="m^2")"area of the section 2";
Real A3(unit="m^2")"area of the section 3";
Real A4(unit="m^2")"area of the section 4";
Real V2(unit="m/s")"velocity in section 2";
Real V3(unit="m/s")"velocity in section 3";
parameter Real p_atm(unit="N/m^2")=1.01325*10^5"pressure at section 1";
Real p2(unit="N/m^2")"pressure at section 2";
Real p3(unit="N/m^2")"pressure at section 3";
Real W_s_dot(unit="W")"output of the turbine";
equation
A2=(1/4)*pi*D2^2;
A3=(1/4)*pi*D3^2;
A4=(1/4)*pi*D4^2;
V2=(V4*A4)/A2;
V3=V2;
p2=p_atm+(1/2)*rho*(V1^2-V2^2)+rho*g*z1_z2;
p3=p_atm+(1/2)*rho*(V4^2-V3^2)+rho*g*z4_z3;
W_s_dot=V4*A4*(p2-p3);



end Ex6_5;
