class Ex1_20
/*start time and stop time should be taken -10 and 15 second respectively to get the result*/
parameter Real pi = Modelica.Constants.pi;

Real theta(unit="rad");/*angular position of the particle*/
Real r(unit="m");/*radial coordinate of the particle*/

Real x(unit="m");/*x-coordinate of the particle*/
Real y(unit="m");/*y-coordinate of the particle*/

Real theta_dot(unit="rad/s");/*1-st derivative of the angle*/
Real theta_ddot(unit="rad/s^2");/*2-nd derivative of the angle*/
Real r_dot(unit="m/s");/*1-st derivative of r*/
Real r_ddot(unit="m/s^2");/*2-nd derivative of r*/

Real a_r(unit="m/s^2");/*r-component of the acceleration of the particle*/
Real a_r_ana(unit="m/s^2");/*analytical equation for the r-component of the acceleration of the particle*/

Real a_theta(unit="m/s^2");/*theta-component of the acceleration of the particle*/
Real a_theta_ana(unit="m/s^2");/*analytical equation for the theta-component of the acceleration of the particle*/

equation
theta=pi*time;
r=exp(0.2*theta);

x=r*cos(theta);
y=r*sin(theta);

theta_dot=der(theta);
theta_ddot=der(theta_dot);
r_dot=der(r);
r_ddot=der(r_dot);

a_r=r_ddot-r*theta_dot^2;
a_r_ana=-0.96*pi^2*exp(0.2*pi*time);

a_theta=r*theta_ddot+2*r_dot*theta_dot;
a_theta_ana=2*(0.2*pi^2)*exp(0.2*pi*time);

end Ex1_20;
