class Ex1_17
parameter Real r(unit="m")=1.2;/*radius of the circular path*/

Real alpha(unit="rad/s^2");/*angular acceleration of the particle*/
Real w(unit="rad/s",start=0);/*angular velocity of the particle*/
Real theta(unit="rad",start=0);/*angular position of the particle*/
Real a_t(unit="m/s^2");/*tangential acceleration*/
Real a_n(unit="m/s^2");/*normal acceleration*/
Real a[2](each unit="m/s^2");/*acceleration of the particle*/
Real a_mag(unit="m/s^2");/*mangitude of the acceleration of the particle*/
equation
alpha=der(w);
der(w)+2*w=3*time^2;
der(theta)=w;
a_t=r*alpha;
a_n=r*w^2;
a={a_t,a_n};
a_mag=Modelica.Math.Vectors.norm(a);
end Ex1_17;
