class Ex3_11
parameter Real g(unit="ft/s^2")=32.2;/*acceleration due to gravity*/
parameter Real m_A(unit="lb")=4000;/*mass of the car A*/
parameter Real m_B(unit="lb")=3600;/*mass of the car B*/
parameter Real mu=0.7;/*coefficient of kinetic friction*/
parameter Real e=0.5;/*coefficient of restitution*/
parameter Real s_A_ac(unit="ft")=30;/*distance covered by car A after collision*/
parameter Real s_B_ac(unit="ft")=50;/*distance covered by car B after collision*/
parameter Real s_A0(unit="ft")=120;/*distance between intial position and collision point for car A*/
parameter Real s_B0(unit="ft")=150;/*distance between intial position and collision point for car B*/

Real v_A_das(unit="ft/s");/*velocty of the car A just after the collision*/
Real v_B_das(unit="ft/s");/*velocty of the car B just after the collision*/
Real v_A(unit="ft/s");/*velocty of the car A just before the collision*/
Real v_B(unit="ft/s");/*velocty of the car B just before the collision*/

Real v_Ai(unit="ft/s");/*initial velocty of the car A*/
Real v_Bi(unit="ft/s");/*initial velocty of the car B*/
equation
v_A_das=sqrt(2*mu*g*s_A_ac);
v_B_das=sqrt(2*mu*g*s_B_ac);
m_A*v_A+m_B*(-v_B)=m_A*(-v_A_das)+m_B*v_B_das;
v_B_das-(-v_A_das)=e*(v_A-(-v_B));
-mu*m_A*g*s_A0=(1/2)*m_A*(v_A^2-v_Ai^2);
-mu*m_B*g*s_B0=(1/2)*m_B*(v_B^2-v_Bi^2);
end Ex3_11;
