class Ex5_13
/*the problem has been solved by VECTOR METHOD*/

parameter Real theta1_deg(unit="deg")=35;/*angle between AB and horizontal plane in degree unit*/
Real theta1(unit="rad");/*angle between AB and horizontal plane in radian unit*/
parameter Real theta2_deg(unit="deg")=45;/*angle between AB and the direction of v_B in degree unit*/
Real theta2(unit="rad");/*angle between AB and the direction of v_B in radian unit*/

parameter Real v_B[3](each unit="in/s")={0,10,0};/*velocity vector of point B*/

Real v_A_mag(unit="in/s");/*magnitude of velocity vector of point A*/
Real v_A[3](each unit="in/s");/*velocity vector of point A*/
Real v_A_R[3](each unit="in/s");/*right hand side of relative velocity equation of point A*/

parameter Real AB(unit="in")=7.2;/*distance between A and B*/
Real r_AB[3](each unit="in");/*position vector of A relative to B*/

Real w_mag(unit="rad/s");/*magnitude of the angular velocity of link AB*/
Real w[3](each unit="rad/s");/*the angular velocity of link AB*/

equation
theta1=Modelica.SIunits.Conversions.from_deg(theta1_deg);
theta2=Modelica.SIunits.Conversions.from_deg(theta2_deg);
v_A=v_A_mag*{cos(theta1),sin(theta1),0};
w=w_mag*{0,0,1};
r_AB=AB*{-cos(theta2),-sin(theta2),0};
v_A_R=v_B+cross(w,r_AB);
v_A[1]=v_A_R[1];
v_A[2]=v_A_R[2];
end Ex5_13;
