class Ex5_15
parameter Real theta_deg(unit="deg")=30;/*angular position of B in degree unit*/
Real theta(unit="rad");/*angular position of B in radian unit*/

parameter Real a(unit="in")=20;/*inner radius of the wheel*/
parameter Real b(unit="in")=40;/*outer radius of the wheel*/
Real r_BC[3](each unit="in");/*position vector of B relative to C*/

parameter Real w[3](each unit="rad/s")={0,0,4};/*the angular velocity of wheel*/

parameter Real v_C[3](each unit="in/s")={0,0,0};/*velocity vector of point C*/

Real v_B[3](each unit="in/s");/*velocity vector of point B*/
Real v_B_mag(unit="in/s");/*magnitude of velocity vector of point B*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
r_BC={0,a,0}+b*{sin(theta),cos(theta),0};
v_B=v_C+cross(w,r_BC);
v_B_mag=Modelica.Math.Vectors.norm(v_B);
end Ex5_15;
