class Ex5_18
parameter Real r(unit="ft")=2;/*inner radius of the cylinder*/
Real r_OC[3](each unit="ft");/*position vector of O relative to C*/

parameter Real w[3](each unit="rad/s")={0,0,-3};/*the angular velocity of cylinder*/
Real w_mag(unit="rad/s");/*magnitude of the angular velocity of cylinder*/

parameter Real v_C[3](each unit="ft/s")={0,0,0};/*velocity vector of point C*/

Real v_O[3](each unit="ft/s");/*velocity vector of point O*/
Real v_O_mag(unit="ft/s");/*magnitude of velocity vector of point O*/
Real v_O_R[3](each unit="ft/s");/*right hand side of relative velocity equation of point O*/


parameter Real alpha[3](each unit="rad/s^2")={0,0,-2};/*magnitude of angular acceleration*/
Real a_C[3](each unit="ft/s^2");/*acceleration of point C*/
Real a_Cy(unit="ft/s^2");/*j-component of acceleration of point C*/
Real a_O[3](each unit="ft/s^2");/*acceleration of point O*/
Real a_O_mag(unit="ft/s^2");/*magnitude of acceleration of point O*/
Real a_O_R[3](each unit="ft/s^2");/*right hand side of relative acceleration equation of point O*/
equation
w_mag=Modelica.Math.Vectors.norm(w);
v_O=v_O_mag*{1,0,0};
r_OC=r*{0,1,0};
v_O_R=v_C+cross(w,r_OC);
v_O[1]=v_O_R[1];
a_C={0,a_Cy,0};
a_O=a_O_mag*{1,0,0};
a_O_R=a_C+cross(alpha,r_OC)-w_mag^2*r_OC;
a_O[1]=a_O_R[1];
a_O[2]=a_O_R[2];
end Ex5_18;
