class Ex5_20
parameter Real AB(unit="mm")=200;/*length of AB*/
parameter Real BC(unit="mm")=250;/*length of BC*/
parameter Real h(unit="mm")=100;/*perpendicular distance between point B and horizontal plane*/

Real theta(unit="rad");/*angle between AB and horizontal plane*/
Real beta(unit="rad");/*angle between CB and horizontal plane*/

Real r_BA[3](each unit="mm");/*position of B relative to A*/
Real r_BC[3](each unit="mm");/*position of B relative to C*/

parameter Real v_A[3](each unit="mm/s")={0,0,0};/*linear velocity vector of point A*/
parameter Real v_C[3](each unit="mm/s")={100,0,0};/*linear velocity vector of point C*/
Real v_B[3](each unit="mm/s");/*linear velocity vector of point B*/
Real v_Bx(unit="mm/s");/*x-component of velocity vector of point B*/
Real v_By(unit="mm/s");/*y-component of velocity vector of point B*/

Real w_AB[3](each unit="rad/s");/*angular velocity of the link AB*/
Real w_AB_k(unit="rad/s");/*k-component of angular velocity of the link AB*/
Real w_BC[3](each unit="rad/s");/*angular velocity of the link BC*/
Real w_BC_k(unit="rad/s");/*k-component of angular velocity of the link BC*/

Real v_B_AB[3];/*velocity vector of point B using link AB*/
Real v_B_BC[3];/*velocity vector of point B using link BC*/

parameter Real a_A[3](each unit="mm/s^2")={0,0,0};/*acceleration vector of point A*/
parameter Real a_C[3](each unit="mm/s^2")={10,0,0};/*acceleration vector of point C*/
Real a_B[3](each unit="mm/s^2");/*acceleration  vector of point B*/

Real alpha_AB[3](each unit="rad/s^2");/*angular acceleration of the link AB*/
Real alpha_AB_k(unit="rad/s^2");/*k-component angular acceleration of the link AB*/
Real alpha_BC[3](each unit="rad/s^2");/*angular acceleration of the link BC*/
Real alpha_BC_k(unit="rad/s^2");/*k-component angular acceleration of the link BC*/

Real a_B_AB[3](each unit="mm/s^2");/*acceleration vector of point B using link AB*/
Real a_B_BC[3](each unit="mm/s^2");/*acceleration vector of point B using link BC*/

equation
sin(theta)=h/AB;
sin(beta)=h/BC;
r_BA=AB*{cos(theta),sin(theta),0};
r_BC=BC*{-cos(beta),sin(beta),0};

v_Bx=v_B[1];
v_By=v_B[2];
v_B=v_B_AB;

w_AB={0,0,w_AB_k};
w_BC={0,0,w_BC_k};

v_B_AB=v_A+cross(w_AB,r_BA);
v_B_BC=v_C+cross(w_BC,r_BC);
v_B_AB[1]=v_B_BC[1];
v_B_AB[2]=v_B_BC[2];

alpha_AB={0,0,alpha_AB_k};
alpha_BC={0,0,alpha_BC_k};
a_B_AB=a_A+cross(alpha_AB,r_BA)-(Modelica.Math.Vectors.norm(w_AB))^2*r_BA;
a_B_BC=a_C+cross(alpha_BC,r_BC)-(Modelica.Math.Vectors.norm(w_BC))^2*r_BC;
a_B_AB[1]=a_B_BC[1];
a_B_AB[2]=a_B_BC[2];

a_B=a_B_AB;
/*The  answer provided for alpha_AB and alpha_BC in the textbook are wrong*/
end Ex5_20;
