class Ex5_27
parameter Real r_A[3](each unit="m")={3,2,-1};/*position vector of body A*/
parameter Real r_B[3](each unit="m")={4,3,2};/*position vector of body B*/

parameter Real v_A[3](each unit="m/s")={0.1,-0.4,0.3};/*linear velocity vector of body A*/
parameter Real v_B[3](each unit="m/s")={0,-0.2,-0.1};/*linear velocity vector of body B*/

parameter Real w_A[3](each unit="rad/s")={1,0,-0.5};/*angular velocity of the body A*/
parameter Real w_B[3](each unit="rad/s")={0.7,-0.3,1.2};/*angular velocity of the body B*/

Real w_H[3](each unit="rad/s");/*angular velocity of B relative to A*/
Real r_BA[3](each unit="m");/*position of B relative to A*/

Real v_eff[3](each unit="m/s");/*effective velocity*/

Real e_wH[3];/*unit vector along helical axis*/
Real v_w[3](each unit="m/s");/*relative velocity component parallel to the helical axis*/
Real p_HB[3](each unit="m");/*pposition of the helical axis from point B*/

equation
w_H=w_B-w_A;
r_BA=r_B-r_A;

v_eff=v_A-v_B+cross(w_A,r_BA);
e_wH=w_H/Modelica.Math.Vectors.norm(w_H);
v_w=-sum(v_eff.*e_wH)*e_wH;

p_HB=cross(w_H,v_eff)/sum(w_H.*w_H);
/*The  answer provided in the textbook is wrong*/

end Ex5_27;
