class Ex5_6
parameter Real Ay(unit="m")=0.6;/*length of Ay*/
parameter Real y0(unit="m")=0.5;/*length of y0*/
Real r_A0_mag(unit="m");/*magnitude of the position vector of A w..r.t 0*/
Real r_A0[3](each unit="m");/*position vector of A w.r.t 0 at full open condition*/

Real theta_0(unit="rad");/*angle between A0 and y0 at closed condition*/
parameter Real theta_deg(unit="deg")=45;/*angle between final A0 and initial A0 at open condition in degree unit*/
Real theta(unit="rad");/*angle between final A0 and initial A0 at open condition in radian unit*/
parameter Real alpha_mag(unit="rad/s^2")=2;/*magnitude of angular acceleration*/
Real alpha[3](each unit="rad/s^2");/*angular acceleration vector*/

Real t(unit="s");/*time required to completely open the door*/
Real w_mag(unit="rad/s");/*magnitude of the angular velocity just before the door fully open*/
Real w[3](each unit="rad/s");/*angular velocity just before the door fully open*/
Real v_A[3](each unit="m/s");/*linear velocity of latch A just before the door fully open*/
Real v_A_mag(unit="m/s");/*manitude of linear velocity of latch A just before the door fully open*/
Real a_A[3](each unit="m/s^2");/*total acceleration of latch A just before the door fully open*/
Real a_A_mag(unit="m/s^2");/*magnitude of total acceleration of latch A just before the door fully open*/
equation
r_A0_mag=sqrt(Ay^2+y0^2);
theta_0=atan(Ay/y0);
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
r_A0=r_A0_mag*{cos(theta_0+theta),sin(theta_0+theta),0};
alpha=alpha_mag*{0,0,-1};

t=sqrt((2*theta)/alpha_mag);
w_mag=sqrt(2*alpha_mag*theta);
w=w_mag*{0,0,-1};
v_A=cross(w,r_A0);
v_A_mag=Modelica.Math.Vectors.norm(v_A);

a_A=cross(alpha,r_A0)+cross(w,v_A);
a_A_mag=Modelica.Math.Vectors.norm(a_A);
/*The  answer provided in the textbook is wrong*/
end Ex5_6;
