class Ex7_2
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real M_f(unit="N.m")=5;/*moment on the pully*/
parameter Real m_A(unit="kg")=20;/*mass of the block A*/
parameter Real m_B(unit="kg")=10;/*mass of the block B*/
parameter Real I_p(unit="kg.m^2")=5;/*moment of inertia of the pully*/
parameter Real r(unit="m")=400/1000;/*radius of the pully*/
parameter Real x_A(unit="m")=0.5;/*distance dropped by mass A*/
parameter Real x_B(unit="m")=-0.5;/*distance covered by mass B in up direction(negative sign indiacte the direction of the mass B(up direction))*/

Real theta(unit="rad");/*rotational angle of pulley*/
Real w(unit="rad/s");/*angular velocity of the pulley*/
Real v_A(unit="m/s",start=0.01);/*velocity of the mass A*/
Real v_B(unit="m/s");/*velocity of the mass B*/
equation
theta=-x_A/r;
w=-v_A/r;
v_B=-v_A;
M_f*theta+m_A*g*x_A+m_B*g*x_B=(1/2)*(I_p*w^2+m_A*v_A^2+m_B*v_B^2);


end Ex7_2;
