class Ex9_10
parameter Real m(unit="kg")=50;/*mass of the system*/
parameter Real k(unit="N/m")=200;/*spring constant*/
parameter Real c(unit="kg/s")=25;/*damping constant*/

/*system with air viscosity*/
Real x_1a(unit="m",start=0);/*position of the mass*/
Real x_2a(unit="m/s",start=1);/*velocity of the mass*/

/*system with linear viscous damping*/
Real x_1b(unit="m",start=0);/*position of the mass*/
Real x_2b(unit="m/s",start=1);/*velocity of the mass*/
equation
/*system with air viscosity*/
der(x_1a)=x_2a;
der(x_2a)=-0.5*x_2a*abs(x_2a)-4*x_1a;

/*system with linear viscous damping*/
der(x_1b)=x_2b;
der(x_2b)=-0.5*x_2b-4*x_1b;
end Ex9_10;
