class Ex9_12
parameter Real pi = Modelica.Constants.pi;


parameter Real m(unit="kg")=300;/*mass of the system*/
parameter Real F_0(unit="N")=10;/*magnitude of the applied force*/
parameter Real w_dr(unit="rad/s")=2;/*frequency of the applied force*/
parameter Real x_max(unit="m")=0.05;/*maximum amplitude of the forced response*/

Real k(unit="N/m");/*spring constant of new spring*/
Real f_0(unit="N/kg");/*magnitude of applied force per unit mass of the system*/
Real w_n(unit="rad/s");/*frequency of the system*/

equation
f_0=F_0/m;
w_n^2=k/m;
x_max=(2*f_0)/(w_n^2-w_dr^2);
end Ex9_12;

