class Ex1_18
/*the stop time should be taken more than 2 second to get the result*/

parameter Real t(unit="s")=2;/*given time*/
Real r[3](each unit="m");/*position vector*/
Real v[3](each unit="m/s");/*velocity vector*/
Real a[3](each unit="m/s^2");/*acceleration vector*/

Real v_2[3](each unit="m/s");/*velocity vector at 2 seconds*/
Real v_2_mag(unit="m/s");/*magnitude of the velocity vector at 2 seconds*/
Real e_t[3];/*unit vector along tangential direction*/

Real a_2[3](each unit="m/s^2");/*acceleration vector at 2 seconds*/
Real a_t[3](each unit="m/s^2");/*tangential acceleration component at 2 seconds*/
Real a_n[3](each unit="m/s^2");/*normal acceleration component at 2 seconds*/
Real a_n_mag(unit="m/s^2");/*magnitude of the normal acceleration component at 2 seconds*/
Real e_n[3];/*unit vector along normal direction*/
Real rho(unit="m");/*radius of curvature of the path*/

Real e_b[3];/*binomial vector*/
equation
r={time^2,3*time,-time^3};
v=der(r);
a=der(v);

when time==t then
v_2=v;
v_2_mag=Modelica.Math.Vectors.norm(v_2);
e_t=v_2/v_2_mag;

a_2=a;
a_t=sum(a_2.*e_t)*e_t;
a_n=a_2-a_t;
a_n_mag=Modelica.Math.Vectors.norm(a_n);
e_n=a_n/a_n_mag;
rho=(v_2*v_2)/a_n_mag;
e_b=cross(e_t,e_n);
end when;

// value of a_t is wrong in the book
end Ex1_18;
